/*
 Shift Register Example
 for TPIC6B595 shift register by Jens C Brynildsen

 This sketch turns reads serial input and uses it to set the pins
 of a TPIC6B595 shift register.

 Hardware:
 * TPIC6B595 shift register attached to pins 7, 8, 11 and 12 of the Arduino,
 as detailed below.
 * LEDs attached to each of the outputs of the shift register

 Based on the example created 23 Mar 2010 by Tom Igoe

 */

//Pin to clear the register
const int clearPin = 7;
//Pin connected to latch pin (ST_CP) of 74HC595
const int latchPin = 8;
//Pin connected to clock pin (SH_CP) of 74HC595
const int clockPin = 12;
////Pin connected to Data in (DS) of 74HC595
const int dataPin = 11;

int counter = 0;
int numLedsInUse = 8;

void setup() {
  //set pins to output because they are addressed in the main loop
  pinMode(clearPin, OUTPUT);
  pinMode(latchPin, OUTPUT);
  pinMode(dataPin, OUTPUT);  
  pinMode(clockPin, OUTPUT);
  Serial.begin(9600);
  Serial.println("*");
  
  // delay a little and then set 
  delay(100);
  // Always start by sentting SRCLR high
  digitalWrite( clearPin, HIGH);
}

void loop() {
  // Display LED's running
  if( counter >= (numLedsInUse-1) ){
    counter = 0;
  } else {
    counter++;
  }
  
  // write to the shift register with the correct bit set high:
  registerWrite(counter, HIGH);
  delay( 100 );
}

// This method sends bits to the shift register:

void registerWrite(int whichPin, int whichState) {
  // the bits you want to send
  byte bitsToSend0 = 0;
  // write number as bits
  bitWrite(bitsToSend0, whichPin, whichState);

  // turn off the output so the pins don't light up
  // while you're shifting bits:
  digitalWrite(latchPin, LOW);
  
  // shift the bits out
  shiftOut(dataPin, clockPin, MSBFIRST, bitsToSend0);

  // turn on the output so the LEDs can light up:
  digitalWrite(latchPin, HIGH);
}
