<?php

$plugin_info = array(
  'pi_name' => 'RemoveDuplicateHtml',
  'pi_version' => '1.0',
  'pi_author' => 'Jensa',
  'pi_author_url' => 'http://www.flashgamer.com/expressionengine/',
  'pi_description' => 'Reads in X lines of HTML code and strips off duplicates.',
  'pi_usage' => RemoveDuplicateHtml::usage()
  );

class RemoveDuplicateHtml
{
	var $return_data = "";

	function RemoveDuplicateHtml()
	{
    	global $TMPL;
		$pre = $TMPL->tagdata;
		$dirty = explode("\n", $pre);
    	$clean = array_unique($dirty);
    	$this->return_data = implode("\n", $clean);
	}

  // ----------------------------------------
  //  Plugin Usage
  // ----------------------------------------
  // This function describes how the plugin is used.
  //  Make sure and use output buffering

	function usage()
	{
		ob_start(); 
		?>
Works as a tag pair. Wrap around any block of output to remove duplicate lines:

{exp:removeduplicatehtml}
  <img src='image1.jpg' width='65' height='30' border='0' class='border_a'/>
  <img src='image1.jpg' width='65' height='30' border='0' class='border_a'/>
  <img src='image2.jpg' width='65' height='30' border='0' class='border_a'/>
  <img src='image2.jpg' width='65' height='30' border='0' class='border_a'/>
{/exp:removeduplicatehtml}

This will produce an output like this:

<img src='image1.jpg' width='65' height='30' border='0' class='border_a'/>
<img src='image2.jpg' width='65' height='30' border='0' class='border_a'/>

	<?php
		$buffer = ob_get_contents();
		ob_end_clean(); 
		return $buffer;
	}
	// END
}

?>